/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.Objects;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ZstdDecompressCtx
extends AutoCloseBase {
    private long nativePtr = ZstdDecompressCtx.init();
    private ZstdDictDecompress decompression_dict = null;

    private static native long init();

    private static native void free(long var0);

    public ZstdDecompressCtx() {
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createDeCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            ZstdDecompressCtx.free(this.nativePtr);
            this.nativePtr = 0L;
        }
    }

    public ZstdDecompressCtx setMagicless(boolean bl) {
        this.ensureOpen();
        this.acquireSharedLock();
        Zstd.setDecompressionMagicless(this.nativePtr, bl);
        this.releaseSharedLock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDecompressCtx loadDict(ZstdDictDecompress zstdDictDecompress) {
        this.ensureOpen();
        this.acquireSharedLock();
        zstdDictDecompress.acquireSharedLock();
        try {
            long l = ZstdDecompressCtx.loadDDictFast0(this.nativePtr, zstdDictDecompress);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            this.decompression_dict = zstdDictDecompress;
        }
        finally {
            zstdDictDecompress.releaseSharedLock();
            this.releaseSharedLock();
        }
        return this;
    }

    private static native long loadDDictFast0(long var0, ZstdDictDecompress var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDecompressCtx loadDict(byte[] bs) {
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long l = ZstdDecompressCtx.loadDDict0(this.nativePtr, bs);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            this.decompression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
        return this;
    }

    private static native long loadDDict0(long var0, byte[] var2);

    public void reset() {
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long l = ZstdDecompressCtx.reset0(this.nativePtr);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long reset0(long var0);

    private void ensureOpen() {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Decompression context is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decompressDirectByteBufferStream(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long l = ZstdDecompressCtx.decompressDirectByteBufferStream0(this.nativePtr, byteBuffer, byteBuffer.position(), byteBuffer.limit(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit());
            if ((l & 0x80000000L) != 0L) {
                long l2 = l & 0xFFL;
                throw new ZstdException(l2, Zstd.getErrorName(l2));
            }
            byteBuffer2.position((int)(l & Integer.MAX_VALUE));
            byteBuffer.position((int)(l >>> 32) & Integer.MAX_VALUE);
            boolean bl = l >>> 63 == 1L;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long decompressDirectByteBufferStream0(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressDirectByteBuffer(ByteBuffer byteBuffer, int i, int j, ByteBuffer byteBuffer2, int k, int l) {
        this.ensureOpen();
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        Objects.checkFromIndexSize(k, l, byteBuffer2.limit());
        Objects.checkFromIndexSize(i, j, byteBuffer.limit());
        this.acquireSharedLock();
        try {
            long l2 = ZstdDecompressCtx.decompressDirectByteBuffer0(this.nativePtr, byteBuffer, i, j, byteBuffer2, k, l);
            if (Zstd.isError(l2)) {
                throw new ZstdException(l2);
            }
            if (l2 > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)l2;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long decompressDirectByteBuffer0(long var0, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressByteArray(byte[] bs, int i, int j, byte[] cs, int k, int l) {
        Objects.checkFromIndexSize(k, l, cs.length);
        Objects.checkFromIndexSize(i, j, bs.length);
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long l2 = ZstdDecompressCtx.decompressByteArray0(this.nativePtr, bs, i, j, cs, k, l);
            if (Zstd.isError(l2)) {
                throw new ZstdException(l2);
            }
            if (l2 > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)l2;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long decompressByteArray0(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressByteArrayToDirectByteBuffer(ByteBuffer byteBuffer, int i, int j, byte[] bs, int k, int l) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        Objects.checkFromIndexSize(k, l, bs.length);
        Objects.checkFromIndexSize(i, j, byteBuffer.limit());
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long l2 = ZstdDecompressCtx.decompressByteArrayToDirectByteBuffer0(this.nativePtr, byteBuffer, i, j, bs, k, l);
            if (Zstd.isError(l2)) {
                throw new ZstdException(l2);
            }
            if (l2 > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)l2;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long decompressByteArrayToDirectByteBuffer0(long var0, ByteBuffer var2, int var3, int var4, byte[] var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decompressDirectByteBufferToByteArray(byte[] bs, int i, int j, ByteBuffer byteBuffer, int k, int l) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        Objects.checkFromIndexSize(k, l, byteBuffer.limit());
        Objects.checkFromIndexSize(i, j, bs.length);
        this.ensureOpen();
        this.acquireSharedLock();
        try {
            long l2 = ZstdDecompressCtx.decompressDirectByteBufferToByteArray0(this.nativePtr, bs, i, j, byteBuffer, k, l);
            if (Zstd.isError(l2)) {
                throw new ZstdException(l2);
            }
            if (l2 > Integer.MAX_VALUE) {
                throw new ZstdException(Zstd.errGeneric(), "Output size is greater than MAX_INT");
            }
            int n = (int)l2;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static native long decompressDirectByteBufferToByteArray0(long var0, byte[] var2, int var3, int var4, ByteBuffer var5, int var6, int var7);

    public int decompress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ZstdException {
        int n = this.decompressDirectByteBuffer(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), byteBuffer2, byteBuffer2.position(), byteBuffer2.limit() - byteBuffer2.position());
        byteBuffer2.position(byteBuffer2.limit());
        byteBuffer.position(byteBuffer.position() + n);
        return n;
    }

    public int decompress(ByteBuffer byteBuffer, byte[] bs) throws ZstdException {
        int n = this.decompressByteArrayToDirectByteBuffer(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), bs, 0, bs.length);
        byteBuffer.position(byteBuffer.position() + n);
        return n;
    }

    public int decompress(byte[] bs, ByteBuffer byteBuffer) throws ZstdException {
        int n = this.decompressDirectByteBufferToByteArray(bs, 0, bs.length, byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
        byteBuffer.position(byteBuffer.limit());
        return n;
    }

    public ByteBuffer decompress(ByteBuffer byteBuffer, int i) throws ZstdException {
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(i);
        int n = this.decompressDirectByteBuffer(byteBuffer2, 0, i, byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
        byteBuffer.position(byteBuffer.limit());
        return byteBuffer2;
    }

    public int decompress(byte[] bs, byte[] cs) {
        return this.decompressByteArray(bs, 0, bs.length, cs, 0, cs.length);
    }

    public byte[] decompress(byte[] bs, int i) throws ZstdException {
        return this.decompress(bs, 0, bs.length, i);
    }

    public byte[] decompress(byte[] bs, int i, int j, int k) throws ZstdException {
        if (k < 0) {
            throw new ZstdException(Zstd.errGeneric(), "Original size should not be negative");
        }
        byte[] byArray = new byte[k];
        int n = this.decompressByteArray(byArray, 0, byArray.length, bs, i, j);
        if (n != k) {
            return Arrays.copyOfRange(byArray, 0, n);
        }
        return byArray;
    }

    static {
        Native.load();
    }
}

