/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2861;
import net.minecraft.class_2867;
import net.minecraft.class_9240;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RegionFileStorageExternalCache
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    @Nullable
    public final class_2867 storage;
    public static final int MAX_CACHE_SIZE = 16;
    public static boolean regionCacheNullPointerWarningSent = false;
    ReentrantLock getRegionFileLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<RegionFileCache> regionFileCache = new ConcurrentLinkedQueue();

    public RegionFileStorageExternalCache(class_2867 storage) {
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public class_2861 getRegionFile(class_1923 pos) throws IOException {
        if (this.storage == null) {
            if (!regionCacheNullPointerWarningSent) {
                regionCacheNullPointerWarningSent = true;
                LOGGER.warn("Unable to access Minecraft's chunk cache. This may be due to another mod changing said cache. DH will be unable to access any Minecraft chunk data until said mod is removed.");
            }
            return null;
        }
        long posLong = class_1923.method_8331((int)pos.method_17885(), (int)pos.method_17886());
        class_2861 rFile = null;
        int retryCount = 0;
        int maxRetryCount = 8;
        while (retryCount < maxRetryCount) {
            ++retryCount;
            try {
                this.getRegionFileLock.lock();
                rFile = (class_2861)this.storage.field_17657.getOrDefault(posLong, null);
                break;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (NullPointerException e) {
                if (regionCacheNullPointerWarningSent) break;
                regionCacheNullPointerWarningSent = true;
                LOGGER.warn("Unable to access Minecraft's chunk cache. This may be due to another mod changing said cache. Falling back to DH's internal cache.");
                break;
            }
            finally {
                this.getRegionFileLock.unlock();
            }
        }
        if (retryCount >= maxRetryCount) {
            BatchGenerationEnvironment.LOAD_LOGGER.warn("Concurrency issue detected when getting region file for chunk at [" + String.valueOf(pos) + "].", new Object[0]);
        }
        if (rFile != null) {
            return rFile;
        }
        for (RegionFileCache cache : this.regionFileCache) {
            if (cache.pos != posLong) continue;
            return cache.file;
        }
        Path storageFolderPath = this.storage.field_18690;
        if (!Files.exists(storageFolderPath, new LinkOption[0])) {
            return null;
        }
        Path regionFilePath = storageFolderPath.resolve("r." + pos.method_17885() + "." + pos.method_17886() + ".mca");
        rFile = new class_2861(new class_9240("level", null, "level type"), regionFilePath, storageFolderPath, false);
        this.regionFileCache.add(new RegionFileCache(class_1923.method_8331((int)pos.method_17885(), (int)pos.method_17886()), rFile));
        while (this.regionFileCache.size() > 16) {
            this.regionFileCache.poll().file.close();
        }
        return rFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public class_2487 read(class_1923 pos) throws IOException {
        class_2861 file = this.getRegionFile(pos);
        if (file == null) {
            return null;
        }
        try (DataInputStream stream = file.method_21873(pos);){
            if (stream == null) {
                class_2487 class_24873 = null;
                return class_24873;
            }
            class_2487 class_24872 = class_2507.method_10627((DataInput)stream);
            return class_24872;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        RegionFileCache cache;
        while ((cache = this.regionFileCache.poll()) != null) {
            cache.file.close();
        }
    }

    private static class RegionFileCache {
        public final long pos;
        public final class_2861 file;

        public RegionFileCache(long pos, class_2861 file) {
            this.pos = pos;
            this.file = file;
        }
    }
}

