/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.immediate.buffer_builder.sorting;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.caffeinemc.mods.sodium.client.util.sorting.VertexSorters;
import net.caffeinemc.mods.sodium.client.util.sorting.VertexSortingExtended;
import net.caffeinemc.mods.sodium.mixin.features.render.immediate.buffer_builder.sorting.MeshDataAccessor;
import net.minecraft.class_4597;
import net.minecraft.class_8251;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_4597.class_4598.class})
public class MultiBufferSourceMixin {
    @Unique
    private static final int VERTICES_PER_QUAD = 6;

    @WrapOperation(method={"method_60893(Lnet/minecraft/class_1921;Lnet/minecraft/class_287;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_9801;method_60819(Lnet/minecraft/class_9799;Lnet/minecraft/class_8251;)Lnet/minecraft/class_9801$class_9802;")})
    private class_9801.class_9802 redirectSortQuads(class_9801 meshData, class_9799 bufferBuilder, class_8251 sorting, Operation<class_9801.class_9802> original) {
        if (!(sorting instanceof VertexSortingExtended)) {
            return (class_9801.class_9802)original.call(new Object[]{meshData, bufferBuilder, sorting});
        }
        VertexSortingExtended sortingExtended = (VertexSortingExtended)sorting;
        MultiBufferSourceMixin.acceleratedSort(meshData, bufferBuilder, sortingExtended);
        return null;
    }

    @Unique
    private static void acceleratedSort(class_9801 meshData, class_9799 bufferBuilder, VertexSortingExtended sorting) {
        class_9801.class_4574 drawState = meshData.method_60822();
        if (drawState.comp_752() != VertexFormat.class_5596.field_27382) {
            return;
        }
        int[] sortedPrimitiveIds = VertexSorters.sort(meshData.method_60818(), drawState.comp_750(), drawState.comp_749().getVertexSize(), sorting);
        class_9799.class_9800 sortedIndexBuffer = MultiBufferSourceMixin.buildSortedIndexBuffer(meshData, bufferBuilder, sortedPrimitiveIds);
        ((MeshDataAccessor)meshData).setIndexBuffer(sortedIndexBuffer);
    }

    @Unique
    private static class_9799.class_9800 buildSortedIndexBuffer(class_9801 meshData, class_9799 bufferBuilder, int[] primitiveIds) {
        VertexFormat.class_5595 indexType = meshData.method_60822().comp_753();
        long ptr = bufferBuilder.method_60808(primitiveIds.length * 6 * indexType.field_27375);
        if (indexType == VertexFormat.class_5595.field_27372) {
            MultiBufferSourceMixin.writeIndexBufferShort(ptr, primitiveIds);
        } else if (indexType == VertexFormat.class_5595.field_27373) {
            MultiBufferSourceMixin.writeIndexBufferInt(ptr, primitiveIds);
        } else {
            throw new UnsupportedOperationException();
        }
        return bufferBuilder.method_60807();
    }

    @Unique
    private static void writeIndexBufferInt(long ptr, int[] primitiveIds) {
        for (int primitiveId : primitiveIds) {
            MemoryUtil.memPutInt((long)(ptr + 0L), (int)(primitiveId * 4 + 0));
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)(primitiveId * 4 + 1));
            MemoryUtil.memPutInt((long)(ptr + 8L), (int)(primitiveId * 4 + 2));
            MemoryUtil.memPutInt((long)(ptr + 12L), (int)(primitiveId * 4 + 2));
            MemoryUtil.memPutInt((long)(ptr + 16L), (int)(primitiveId * 4 + 3));
            MemoryUtil.memPutInt((long)(ptr + 20L), (int)(primitiveId * 4 + 0));
            ptr += 24L;
        }
    }

    @Unique
    private static void writeIndexBufferShort(long ptr, int[] primitiveIds) {
        for (int primitiveId : primitiveIds) {
            MemoryUtil.memPutShort((long)(ptr + 0L), (short)((short)(primitiveId * 4 + 0)));
            MemoryUtil.memPutShort((long)(ptr + 2L), (short)((short)(primitiveId * 4 + 1)));
            MemoryUtil.memPutShort((long)(ptr + 4L), (short)((short)(primitiveId * 4 + 2)));
            MemoryUtil.memPutShort((long)(ptr + 6L), (short)((short)(primitiveId * 4 + 2)));
            MemoryUtil.memPutShort((long)(ptr + 8L), (short)((short)(primitiveId * 4 + 3)));
            MemoryUtil.memPutShort((long)(ptr + 10L), (short)((short)(primitiveId * 4 + 0)));
            ptr += 12L;
        }
    }
}

