/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.NemosInventorySortingClientCommon;
import com.nemonotfound.nemos.inventory.sorting.config.DefaultConfigValues;
import com.nemonotfound.nemos.inventory.sorting.config.model.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.config.service.ConfigService;
import com.nemonotfound.nemos.inventory.sorting.factory.ButtonCreator;
import com.nemonotfound.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.MoveAllButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.MoveSameButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.SortButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.helper.ButtonTypeMapping;
import com.nemonotfound.nemos.inventory.sorting.model.Offset;
import com.nemonotfound.nemos.inventory.sorting.model.Position;
import com.nemonotfound.nemos.inventory.sorting.model.Size;
import com.nemonotfound.nemos.inventory.sorting.model.SlotRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1708;
import net.minecraft.class_1714;
import net.minecraft.class_1718;
import net.minecraft.class_1723;
import net.minecraft.class_1733;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3705;
import net.minecraft.class_3706;
import net.minecraft.class_3803;
import net.minecraft.class_3858;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_8881;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class AbstractContainerScreenMixin
extends class_437 {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    protected int field_25270;
    @Shadow
    protected int field_2792;
    @Unique
    private int nemosInventorySorting$inventoryEndIndex;
    @Unique
    private int nemosInventorySorting$containerSize;
    @Unique
    private final ConfigService nemosInventorySorting$configService = ConfigService.getInstance();
    @Unique
    private final List<class_339> nemosInventorySorting$widgets = new ArrayList<class_339>();

    protected AbstractContainerScreenMixin(class_2561 component) {
        super(component);
    }

    @Inject(method={"method_25426()V"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        class_1703 menu = ((class_465)this).method_17577();
        this.nemosInventorySorting$inventoryEndIndex = menu.field_7761.size() - 9;
        if (menu instanceof class_1723) {
            --this.nemosInventorySorting$inventoryEndIndex;
        }
        this.nemosInventorySorting$containerSize = this.nemosInventorySorting$inventoryEndIndex - 27;
        if (NemosInventorySortingClientCommon.MOD_LOADER_HELPER.isModLoaded("nemos_backpacks") && menu instanceof class_1723) {
            --this.nemosInventorySorting$inventoryEndIndex;
            --this.nemosInventorySorting$containerSize;
        }
        List<ComponentConfig> componentConfigs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        if (this.nemosInventorySorting$shouldHaveStorageContainerButtons()) {
            this.nemosInventorySorting$initStorageContainerButtons(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveInventoryButtons()) {
            this.nemosInventorySorting$initInventoryButtons(componentConfigs);
        }
        if (this.nemosInventorySorting$shouldHaveContainerInventorySortingButtons()) {
            this.nemosInventorySorting$initContainerInventoryButtons(componentConfigs);
        }
        for (class_339 widget : this.nemosInventorySorting$widgets) {
            this.method_37063((class_364)widget);
        }
    }

    protected void method_37067() {
        this.nemosInventorySorting$widgets.clear();
        super.method_37067();
    }

    @Inject(method={"method_25404(Lnet/minecraft/class_11908;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(class_11908 keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.method_25404(keyEvent))) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean method_16803(@NotNull class_11908 keyEvent) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.method_16803(keyEvent))) {
            return true;
        }
        return super.method_16803(keyEvent);
    }

    @Inject(method={"method_25402(Lnet/minecraft/class_11909;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClicked(class_11909 mouseButtonEvent, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.method_25402(mouseButtonEvent, bl))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private boolean nemosInventorySorting$triggerActionOnWidget(Function<class_339, Boolean> function) {
        for (class_339 widget : this.nemosInventorySorting$widgets) {
            if (!function.apply(widget).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveStorageContainerButtons() {
        class_1703 menu = ((class_465)this).method_17577();
        return menu instanceof class_1707 || menu instanceof class_1733 || this.nemosInventorySorting$isModdedContainerMenu(menu, "nemos_backpacks", "com.nemonotfound.nemos.backpacks.world.inventory.BackpackMenu") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfchest", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfbarrel", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler") || this.nemosInventorySorting$isModdedContainerMenu(menu, "reinfshulker", "atonkish.reinfcore.screen.ReinforcedStorageScreenHandler");
    }

    @Unique
    private boolean nemosInventorySorting$isModdedContainerMenu(class_1703 menu, String modId, String className) {
        if (NemosInventorySortingClientCommon.MOD_LOADER_HELPER.isModLoaded(modId)) {
            try {
                Class<?> clazz = Class.forName(className);
                if (clazz.isInstance(menu)) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveInventoryButtons() {
        return ((class_465)this).method_17577() instanceof class_1723;
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveContainerInventorySortingButtons() {
        class_1703 menu = ((class_465)this).method_17577();
        return menu instanceof class_1718 || menu instanceof class_3858 || menu instanceof class_3706 || menu instanceof class_3705 || menu instanceof class_1714 || menu instanceof class_8881 || menu instanceof class_3803 || menu instanceof class_1708;
    }

    @Unique
    private void nemosInventorySorting$initStorageContainerButtons(List<ComponentConfig> componentConfigs) {
        int defaultInventoryYOffset = ((class_465)this).method_17577() instanceof class_1733 ? this.field_25270 - 1 : this.field_25270 - 2;
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_STORAGE_CONTAINER, SortButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER, MoveSameButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER, MoveAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER, DropAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_CONTAINER, false), new ButtonTypeMapping(DefaultConfigValues.SORT_STORAGE_CONTAINER_INVENTORY, SortButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.MOVE_SAME_STORAGE_CONTAINER_INVENTORY, MoveSameButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.MOVE_ALL_STORAGE_CONTAINER_INVENTORY, MoveAllButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_STORAGE_CONTAINER_INVENTORY, DropAllButtonFactory.getInstance(), defaultInventoryYOffset, true));
    }

    @Unique
    private void nemosInventorySorting$initInventoryButtons(List<ComponentConfig> componentConfigs) {
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_INVENTORY, SortButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_INVENTORY, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_INVENTORY, DropAllButtonFactory.getInstance(), DefaultConfigValues.Y_OFFSET_INVENTORY, true));
    }

    @Unique
    private void nemosInventorySorting$initContainerInventoryButtons(List<ComponentConfig> componentConfigs) {
        int defaultInventoryYOffset = this.field_25270 - 1;
        this.nemosInventorySorting$createButtons(componentConfigs, new ButtonTypeMapping(DefaultConfigValues.SORT_CONTAINER_INVENTORY, SortButtonFactory.getInstance(), defaultInventoryYOffset, true), new ButtonTypeMapping(DefaultConfigValues.DROP_ALL_CONTAINER_INVENTORY, DropAllButtonFactory.getInstance(), defaultInventoryYOffset, true));
    }

    @Unique
    private void nemosInventorySorting$createButtons(List<ComponentConfig> configs, ButtonTypeMapping ... mappings) {
        for (ButtonTypeMapping mapping : mappings) {
            ComponentConfig config;
            Optional<ComponentConfig> optionalConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, mapping.componentName());
            if (optionalConfig.isEmpty() || !(config = optionalConfig.get()).isEnabled()) continue;
            int yOffset = config.yOffset() != null ? config.yOffset().intValue() : mapping.defaultYOffset();
            int xOffset = config.xOffset() != null ? config.xOffset() : this.field_2792 + config.rightXOffset();
            this.nemosInventorySorting$createButton(mapping.factory(), mapping.isInventoryButton(), new Offset(xOffset, yOffset), new Size(config.width(), config.height(), DefaultConfigValues.BUTTON_SIZE));
        }
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator<?> buttonCreator, boolean isInventoryButton, Offset offset, Size size) {
        int startIndex = isInventoryButton ? this.nemosInventorySorting$containerSize : 0;
        int endIndex = isInventoryButton ? this.nemosInventorySorting$inventoryEndIndex : this.nemosInventorySorting$containerSize;
        SlotRange slotRange = new SlotRange(startIndex, endIndex);
        this.nemosInventorySorting$createButton(buttonCreator, slotRange, offset, size);
    }

    @Unique
    private void nemosInventorySorting$createButton(ButtonCreator<?> buttonCreator, SlotRange slotRange, Offset offset, Size size) {
        Position position = new Position(this.field_2776, this.field_2800);
        Object sortButton = buttonCreator.createButton(slotRange, position, offset, size, ((class_465)this).method_17577());
        this.nemosInventorySorting$widgets.add((class_339)sortButton);
    }
}

