/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.client.InventorySortingKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.config.DefaultConfigValues;
import com.nemonotfound.nemos.inventory.sorting.config.model.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.config.model.FilterConfig;
import com.nemonotfound.nemos.inventory.sorting.config.service.ConfigService;
import com.nemonotfound.nemos.inventory.sorting.gui.components.FilterBox;
import com.nemonotfound.nemos.inventory.sorting.gui.components.buttons.ToggleFilterPersistenceButton;
import com.nemonotfound.nemos.inventory.sorting.model.FilterResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_1735;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class ContainerFilterMixin
extends class_437 {
    @Unique
    private static final class_2960 HIGHLIGHTED_SLOT = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/highlighted_slot");
    @Unique
    private static final class_2960 HIGHLIGHTED_SLOT_INCLUDED_ITEM = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/highlighted_slot_included_item");
    @Unique
    private static final class_2960 DIMMED_SLOT = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/dimmed_slot");
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Unique
    private FilterBox nemosInventorySorting$filterBox;
    @Unique
    private FilterConfig nemosInventorySorting$filterConfig;
    @Unique
    private int nemosInventorySorting$filterBoxWidth = 0;
    @Unique
    private final ConfigService nemosInventorySorting$configService = ConfigService.getInstance();

    protected ContainerFilterMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"method_25426()V"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        List<ComponentConfig> componentConfigs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        if (this.nemosInventorySorting$shouldHaveFilter()) {
            this.nemosInventorySorting$filterConfig = this.nemosInventorySorting$configService.readOrGetDefaultFilterConfig();
            this.nemosInventorySorting$initFilter(componentConfigs);
        }
    }

    @Inject(method={"method_25419()V"}, at={@At(value="TAIL")})
    private void onClose(CallbackInfo ci) {
        if (this.nemosInventorySorting$filterBox == null) {
            return;
        }
        this.nemosInventorySorting$filterBox.updateAndSaveFilter(this.nemosInventorySorting$filterConfig);
    }

    @Inject(method={"method_25404(Lnet/minecraft/class_11908;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(class_11908 keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$filterBox != null) {
            if (this.nemosInventorySorting$filterBox.method_25370() && keyEvent.comp_4795() != 256) {
                cir.setReturnValue((Object)this.nemosInventorySorting$filterBox.method_25404(keyEvent));
                return;
            }
            if (!this.nemosInventorySorting$filterBox.method_25370() && keyEvent.method_74240() && InventorySortingKeyMappings.QUICK_SEARCH.get().method_1417(keyEvent)) {
                this.nemosInventorySorting$handleQuickSearch(cir);
                return;
            }
        }
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.method_25404(keyEvent))) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean method_16803(@NotNull class_11908 keyEvent) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.method_16803(keyEvent))) {
            return true;
        }
        return super.method_16803(keyEvent);
    }

    @Inject(method={"method_25402(Lnet/minecraft/class_11909;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClicked(class_11909 mouseButtonEvent, boolean isDoubleClick, CallbackInfoReturnable<Boolean> cir) {
        Optional optional = this.method_19355(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799());
        if (optional.isEmpty()) {
            for (class_364 guiEventListener : this.method_25396()) {
                guiEventListener.method_25365(false);
            }
        }
        if (this.nemosInventorySorting$filterBox != null && !this.nemosInventorySorting$filterBox.method_25370() && mouseButtonEvent.method_74240() && InventorySortingKeyMappings.QUICK_SEARCH.get().method_1433(mouseButtonEvent)) {
            this.nemosInventorySorting$handleQuickSearch(cir);
            return;
        }
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.method_25402(mouseButtonEvent, isDoubleClick))) {
            cir.setReturnValue((Object)true);
        }
        if (this.nemosInventorySorting$filterBox != null && !this.nemosInventorySorting$filterBox.method_25402(mouseButtonEvent, isDoubleClick) && this.method_25399() == this.nemosInventorySorting$filterBox) {
            this.method_25395(null);
        }
    }

    @Unique
    private void nemosInventorySorting$handleQuickSearch(CallbackInfoReturnable<Boolean> cir) {
        int filterBoxY;
        int filterBoxX = this.nemosInventorySorting$filterBox.method_46426();
        Optional optionalGuiEventListener = this.method_19355(filterBoxX, filterBoxY = this.nemosInventorySorting$filterBox.method_46427());
        if (optionalGuiEventListener.isEmpty()) {
            return;
        }
        this.method_25395((class_364)optionalGuiEventListener.get());
        this.nemosInventorySorting$filterBox.method_25365(true);
        this.nemosInventorySorting$filterBox.method_25348(new class_11909((double)filterBoxX, (double)filterBoxY, new class_11910(0, 0)), false);
        cir.setReturnValue((Object)true);
    }

    @Unique
    private boolean nemosInventorySorting$triggerActionOnWidget(Function<class_364, Boolean> function) {
        for (class_364 widget : this.method_25396()) {
            if (!(widget instanceof ToggleFilterPersistenceButton) || !function.apply(widget).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"method_71085(Lnet/minecraft/class_332;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_465;method_64508(Lnet/minecraft/class_332;II)V")})
    void renderHighlightedSlot(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.method_1882();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<class_1735>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((class_2371<class_1735>)this.nemosInventorySorting$getThis().method_17577().field_7761, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.INCLUDED), guiGraphics, HIGHLIGHTED_SLOT);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.HAS_INCLUDED_ITEM), guiGraphics, HIGHLIGHTED_SLOT_INCLUDED_ITEM);
        }
    }

    @Inject(method={"method_71085(Lnet/minecraft/class_332;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_465;method_64242(Lnet/minecraft/class_332;)V", shift=At.Shift.AFTER)})
    void renderDimmedSlot(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.method_1882();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<class_1735>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((class_2371<class_1735>)this.nemosInventorySorting$getThis().method_17577().field_7761, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.EXCLUDED), guiGraphics, DIMMED_SLOT);
        }
    }

    @Unique
    private void nemosInventorySorting$initFilter(List<ComponentConfig> configs) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, DefaultConfigValues.ITEM_FILTER);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        this.nemosInventorySorting$filterBoxWidth = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : 1;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        this.nemosInventorySorting$createSearchBox(xOffset, yOffset, this.nemosInventorySorting$filterBoxWidth, config.height(), this.nemosInventorySorting$filterConfig.getFilter());
        this.nemosInventorySorting$createButton(configs, DefaultConfigValues.FILTER_PERSISTENCE_TOGGLE);
    }

    @Unique
    private void nemosInventorySorting$createSearchBox(int xOffset, int yOffset, int width, int height, String filter) {
        this.nemosInventorySorting$filterBox = new FilterBox(this.field_22793, this.field_2776, this.field_2800, xOffset, yOffset, width, height, (class_2561)class_2561.method_43471((String)"nemos_inventory_sorting.itemFilter"));
        this.method_37063((class_364)this.nemosInventorySorting$filterBox);
        this.nemosInventorySorting$filterBox.method_1852(filter);
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configs, String componentName) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int width = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : this.nemosInventorySorting$filterBoxWidth + 3;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        class_5250 buttonName = class_2561.method_43471((String)"nemos_inventory_sorting.gui.toggleFilterPersistence");
        ToggleFilterPersistenceButton button = new ToggleFilterPersistenceButton(this.field_2776 + xOffset, this.field_2800 + yOffset, xOffset, width, config.height(), (class_2561)buttonName, this.nemosInventorySorting$filterConfig);
        this.method_37063((class_364)button);
    }

    @Unique
    private void nemosInventorySorting$markSlots(List<class_1735> slots, class_332 guiGraphics, class_2960 texture) {
        if (slots == null) {
            return;
        }
        for (class_1735 slot : slots) {
            guiGraphics.method_52706(class_10799.field_56883, texture, slot.field_7873, slot.field_7872, 16, 16);
        }
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveFilter() {
        return !(this.nemosInventorySorting$getThis().method_17577() instanceof class_481.class_483);
    }

    @Unique
    private class_465<?> nemosInventorySorting$getThis() {
        return (class_465)this;
    }
}

