/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.service;

import com.nemonotfound.nemos.inventory.sorting.model.SlotItem;
import com.nemonotfound.nemos.inventory.sorting.service.MergingService;
import com.nemonotfound.nemos.inventory.sorting.service.SortingService;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1703;

public class InventoryService {
    private static InventoryService INSTANCE;
    private final SortingService sortingService;
    private final MergingService mergeService;

    private InventoryService(MergingService mergeService, SortingService sortingService) {
        this.mergeService = mergeService;
        this.sortingService = sortingService;
    }

    public static InventoryService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InventoryService(MergingService.getInstance(), SortingService.getInstance());
        }
        return INSTANCE;
    }

    public void handleSorting(class_1703 menu, int startIndex, int endIndex) {
        int containerId = menu.field_7763;
        this.handleMerging(menu, startIndex, endIndex, containerId);
        List<SlotItem> slotItemsToSort = this.sortingService.sortSlotItems(menu, startIndex, endIndex);
        Map<Integer, Integer> slotSwapMap = this.sortingService.retrieveSlotSwapMap(slotItemsToSort, startIndex);
        this.sortingService.sortItemsInInventory(menu, slotSwapMap, containerId);
        this.handleMerging(menu, startIndex, endIndex, containerId);
    }

    private void handleMerging(class_1703 menu, int startIndex, int endIndex, int containerId) {
        List<SlotItem> slotItemsToMerge = this.sortingService.sortSlotItems(menu, startIndex, endIndex);
        this.mergeService.mergeAllItems(menu, slotItemsToMerge, containerId);
    }
}

