/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.service;

import com.nemonotfound.nemos.inventory.sorting.Constants;
import com.nemonotfound.nemos.inventory.sorting.model.SlotItem;
import com.nemonotfound.nemos.inventory.sorting.service.SlotSwappingService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_9323;

public class MergingService {
    private static MergingService INSTANCE;
    private final SlotSwappingService inventorySwapService;
    private final class_310 minecraft;

    private MergingService(SlotSwappingService inventorySwapService, class_310 minecraft) {
        this.inventorySwapService = inventorySwapService;
        this.minecraft = minecraft;
    }

    public static MergingService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MergingService(SlotSwappingService.getInstance(), class_310.method_1551());
        }
        return INSTANCE;
    }

    public void mergeAllItems(class_1703 menu, List<SlotItem> sortedSlotItems, int containerId) {
        Map<class_9323, List<SlotItem>> groupedItemMap = sortedSlotItems.stream().collect(Collectors.groupingBy(slotItem -> slotItem.itemStack().method_57353()));
        groupedItemMap.forEach((key, slotItems) -> this.mergeItems(menu, (List<SlotItem>)slotItems, containerId));
    }

    private void mergeItems(class_1703 menu, List<SlotItem> slotItems, int containerId) {
        if (slotItems.size() <= 1) {
            return;
        }
        int leftSlotIndex = 0;
        int rightSlotIndex = slotItems.size() - 1;
        int remainingCycles = 1000;
        while (leftSlotIndex < rightSlotIndex && remainingCycles-- > 0) {
            SlotItem leftSlotItem = slotItems.get(leftSlotIndex);
            SlotItem rightSlotItem = slotItems.get(rightSlotIndex);
            class_1735 leftSlot = (class_1735)menu.field_7761.get(leftSlotItem.slotIndex());
            class_1735 rightSlot = (class_1735)menu.field_7761.get(rightSlotItem.slotIndex());
            class_1799 leftItem = leftSlot.method_7677();
            if (!this.isFullStack(leftItem)) {
                this.inventorySwapService.performSlotSwap(menu, this.minecraft.field_1761, containerId, rightSlotItem.slotIndex(), leftSlotItem.slotIndex(), this.minecraft.field_1724);
            } else {
                ++leftSlotIndex;
            }
            if (!rightSlot.method_7677().method_7960()) continue;
            --rightSlotIndex;
        }
        if (remainingCycles <= 0) {
            Constants.LOG.warn("Merging items exceeded cycle limit. Please report this.");
        }
    }

    private boolean isFullStack(class_1799 itemStack) {
        return itemStack.method_7947() >= itemStack.method_7914();
    }
}

