/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.fullDatafile.IDataSourceUpdateListenerFunc;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.WillNotClose;

public class ClientLevelModule
implements Closeable,
IDataSourceUpdateListenerFunc<FullDataSourceV2> {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private final IDhClientLevel clientLevel;
    @WillNotClose
    public final FullDataSourceProviderV2 fullDataSourceProvider;
    public final AtomicReference<ClientRenderState> ClientRenderStateRef = new AtomicReference();
    public final GenericObjectRenderer genericRenderer = new GenericObjectRenderer();

    public ClientLevelModule(IDhClientLevel clientLevel) {
        this.clientLevel = clientLevel;
        this.fullDataSourceProvider = this.clientLevel.getFullDataProvider();
        this.fullDataSourceProvider.addDataSourceUpdateListener(this);
    }

    public void clientTick() {
        if (!MC_CLIENT.playerExists()) {
            return;
        }
        ClientRenderState clientRenderState = this.ClientRenderStateRef.get();
        if (clientRenderState == null) {
            return;
        }
        if (clientRenderState.quadtree.blockRenderDistanceDiameter != Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius.get() * 16 * 2) {
            if (!this.ClientRenderStateRef.compareAndSet(clientRenderState, null)) {
                return;
            }
            clientRenderState.close();
            clientRenderState = new ClientRenderState(this.clientLevel, this.clientLevel.getFullDataProvider());
            if (!this.ClientRenderStateRef.compareAndSet(null, clientRenderState)) {
                LOGGER.warn("Failed to set render state due to concurrency after changing view distance", new Object[0]);
                clientRenderState.close();
                return;
            }
        }
        clientRenderState.quadtree.tick(new DhBlockPos2D(MC_CLIENT.getPlayerBlockPos()));
    }

    public void startRenderer() {
        ClientRenderState ClientRenderState2 = new ClientRenderState(this.clientLevel, this.clientLevel.getFullDataProvider());
        if (!this.ClientRenderStateRef.compareAndSet(null, ClientRenderState2)) {
            LOGGER.warn("Failed to start renderer due to concurrency", new Object[0]);
            ClientRenderState2.close();
        }
    }

    public boolean isRendering() {
        return this.ClientRenderStateRef.get() != null;
    }

    public void stopRenderer() {
        LOGGER.info("Stopping renderer for " + this, new Object[0]);
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 == null) {
            LOGGER.warn("Tried to stop renderer for " + this + " when it was not started!", new Object[0]);
            return;
        }
        while (!this.ClientRenderStateRef.compareAndSet(ClientRenderState2, null)) {
            ClientRenderState2 = this.ClientRenderStateRef.get();
            if (ClientRenderState2 != null) continue;
            return;
        }
        ClientRenderState2.close();
    }

    public CompletableFuture<Void> updateDataSourcesAsync(FullDataSourceV2 data) {
        return this.clientLevel.getFullDataProvider().updateDataSourceAsync(data);
    }

    @Override
    public void OnDataSourceUpdated(FullDataSourceV2 updatedFullDataSource) {
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 != null) {
            ClientRenderState2.quadtree.reloadPos(updatedFullDataSource.getPos());
        }
    }

    @Override
    public void close() {
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 != null) {
            while (!this.ClientRenderStateRef.compareAndSet(ClientRenderState2, null) && (ClientRenderState2 = this.ClientRenderStateRef.get()) != null) {
            }
            if (ClientRenderState2 != null) {
                ClientRenderState2.close();
            }
        }
        this.fullDataSourceProvider.removeDataSourceUpdateListener(this);
    }

    public void clearRenderCache() {
        ClientRenderState ClientRenderState2;
        IClientLevelWrapper clientLevelWrapper = this.clientLevel.getClientLevelWrapper();
        if (clientLevelWrapper != null) {
            clientLevelWrapper.clearBlockColorCache();
        }
        if ((ClientRenderState2 = this.ClientRenderStateRef.get()) != null && ClientRenderState2.quadtree != null) {
            ClientRenderState2.quadtree.clearRenderDataCache();
        }
    }

    public void reloadPos(long pos) {
        ClientRenderState clientRenderState = this.ClientRenderStateRef.get();
        if (clientRenderState != null && clientRenderState.quadtree != null) {
            clientRenderState.quadtree.reloadPos(pos);
        }
    }

    public static class ClientRenderState
    implements Closeable {
        private static final DhLogger LOGGER = new DhLoggerBuilder().build();
        public final LodQuadTree quadtree;
        public final RenderBufferHandler renderBufferHandler;

        public ClientRenderState(IDhClientLevel dhClientLevel, FullDataSourceProviderV2 fullDataSourceProvider) {
            this.quadtree = new LodQuadTree(dhClientLevel, Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius.get() * 16 * 2, 0, 0, fullDataSourceProvider);
            this.renderBufferHandler = new RenderBufferHandler(this.quadtree);
        }

        @Override
        public void close() {
            LOGGER.info("Shutting down " + ClientRenderState.class.getSimpleName(), new Object[0]);
            this.quadtree.close();
        }
    }
}

